; Script name: Adapt It Unicode - Minimal.iss
; Author: Bill Martin, Erik Brommers
; Purpose: This script creates the Adapt It MINIMl installer 'Adapt_It_WX_<version>_Unicode_Minimal.exe' 
; installer.
;   This script draws its files from the 'setup Unicode - Minimal' staging folder of the developer's 
;   adaptit working tree. The execution of this Adapt It Unicode - Minimal.iss script is the last stage in 
;   the creation of the minimal installer for the Windows version of Adapt It (See "Prerequisites" below.)
;   The installer produced by this script Adapt_It_WX_<version>_Unicode_Minimal.exe can be uploaded from 
;   the developer's adaptit/AIWXInstallers folder to the adapt-it.org website using WinSCP.
; Prerequisites: IMPORTANT: BEFORE RUNNING/EXECUTING THIS SCRIPT YOU SHOULD HAVE DONE THE FOLLOWING Steps:
;   1. Complete all coding changes for a new release of the Adapt It application.
;   2. Do a Unicode Release build within Visual Studio. The Visual Studio's Post-Build Events
;      will copy the newly built Adapt_It_Unicode.exe file to the staging folder named
;      'adaptit/setup Unicode - Minimal'.
;   3. Open and compile the 'Adapt It Unicode Git.iss' script before compiling this script. The 
;      'Adapt It Unicode Git.iss' script won't compile unless it finds a copy of our git downloader 
;      Git_Downloader2_32_1_4AI.exe in the 'adaptit/setup Git' staging folder. Compiling the Git iss
;      script ensures that there is a fresh up-to-date copy of the git downloader in that staging folder, 
;      so you should COMPILE the 'Adapt It Unicode Git.iss' script BEFORE compiling this script.
;   4. Execute the batch file named 'CallAllBatchSetups.bat' that is located in the top-level
;      adaptit folder of the developer's tree. That batch file populates the various staging
;      folders with the updated files from other folders in the tree, in preparation for the
;      compiling/running of this 'Adapt It Unicode - Minimal.iss' Inno Setup script.
;   5. Open and check the version number defines in the VersionNumbersAIandGit.h header file
;      which is located in the same Inno_Setup_Scripts folder. The AI_VERSION_MAJOR, AI_VERSION_MINOR,
;      and AI_REVISION defines should match the current version of the Adapt It installer
;      that this script is creating an installer for. The GIT_VERSION_MAJOR, GIT_VERSION_MINOR, and
;      GIT_REVISION defines should match the version number of the latest Git installer
;      that is available at: https://git-scm.com/downloads. Edit those files to ensure the proper
;      version numbers are defined.
;   6. Finally, once the above pre-requisites are met, compile this script using the Inno Setup Compiler. 
;      It should compile without error (if not contact Bill Martin!). The installer that this script
;      creates is stored in the 'adaptit/AIWX Installers/' folder where it and the other installers
;      created for an Adapt It release can be uploaded to https://adapt-it.org using WinSCP.
; Source/Credits: 
; This ccript was initially generated by the Inno Setup Script Wizard and informed by
; the example scripts supplied with an installation of Inno Setup.
; See the Inno Setup documentation for details on creating Inoo Setup script files!
; Revisions:
; edb 11 Oct 2013: Include InnoTools Downloader for installing Git
; (this is the local version in the Inno_Setup_Scripts directory). This needs
; the following [now obsolete]:
; - itdownload.dll    // DLL that allows us to download 3rd party apps
; - it_download.iss   // ITD script to connect the DLL
; whm 25 Mar 2017: Code changes to enhance the installer and provide more flexible and 
; economic Git installation options. 
; whm 25Jun2018 Updated version of Git to 2.18.0 and Git_Downloader to 2_18_0.
; See also the Adapt It Unicode Git.iss script which creates a special 
; Git_Downloader2_18_0_4AI.exe installer that is now included in the [Files] section below. 
; The Git_Downloader2_18_0_4AI.exe installer is used by the main Adapt It program
; when it is desired to install a missing Git program that didn't get installed at the
; time Adapt It itself was installed (or removed after Adapt It was installed).
; IMPORTANT: RUN THE Adapt It Unicode Git.iss SCRIPT TO CREATE Git_Downloader2_32_0_4AI.exe
; BEFORE COMPILING THIS SCRIPT
; whm 4 April 2017: Removed rdwrtp7.exe and related Windows dlls from the Adapt It installers.
; whm 28 January 2021: Added the Windows *exe utility files for KB sharing
; whm 13 February 2021: Removed the Windows *.exe utility files
; whm 2July2021 updated the 32-bit Git download URL and Git version to 2.32.0, 
;   The GitSetupURL now uses https:// instead of http://.
;   The old it_download.iss ITD system stopped working, so we switched to useInno Setup's 
;   built-in DownloadPage creation, and downloading capabilities in the Adapt It installer 
;   scripts.
;   Downloading of the Git installer is now not done from the Adapt It installer scripts but
;   only from our custom installer Git_Downloader_<version>_4AI.exe, which is generated by
;   the Adapt It Unicode Git.iss script. See that script to see how it works.

; IMPORTANT TODO: designate the version numbers in the following header file within the
; adaptit/source folder. The version numbers in this header file are the only location
; where all the Inno Setup scripts get their version numbers in the form of:
;   #define AI_VERSION_MAJOR 6
;   #define AI_VERSION_MINOR 11
;   #define AI_VERSION_BUILD_PART 1
; and
;   #define GIT_VERSION_MAJOR 2
;   #define GIT_VERSION_MINOR 32
;   #define GIT_REVISION 0
#include "../source/_AIandGitVersionNumbers.h"

#define AIAppName "Adapt It WX Unicode"
#define AIAppVersion Str(AI_VERSION_MAJOR) + "." +Str(AI_VERSION_MINOR) + "." + Str(AI_VERSION_BUILD_PART) ; 6.11.0
#define AIAppUnderscoreVersion Str(AI_VERSION_MAJOR) + "_" +Str(AI_VERSION_MINOR) + "_" + Str(AI_VERSION_BUILD_PART) ; 6_11_0
#define AIInstallerCopyright "2024 by Bruce Waters, Bill Martin, SIL International"
#define AIInstallerPublisher "Adapt It"
#define AIAppURL "http://www.adapt-it.org/"
#define AIAppFullName "Adapt_It_Unicode.exe"
#define AIAppShortName "Adapt It"
#define GitAppVersion Str(GIT_VERSION_MAJOR) + "." +Str(GIT_VERSION_MINOR) + "." + Str(GIT_REVISION) ; 2.32.0
#define GitAppUnderscoredVersion Str(GIT_VERSION_MAJOR) + "_" +Str(GIT_VERSION_MINOR) + "_" + Str(GIT_REVISION) ; 2_32_0
#define GitInstallerFullName "Git-" + GitAppVersion + "-32-bit.exe" ; Git-2.32.0-32-bit.exe 
#define GitDownloaderFullName "Git_Downloader_" + GitAppUnderscoredVersion + "_4AI.exe" ; Git_Downloader_2_32_0_4AI.exe
#define GitGitHubSetupURL "https://github.com/git-for-windows/git/releases/download/v" + GitAppVersion + ".windows.1/" + GitInstallerFullName
#define RepoBase ".."

; RepoStagingFolder differs in the 5 app installers
#define RepoStagingFolder "setup Unicode - Minimal"

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppID={{7317EA81-BC6E-4A4F-AE2B-44ADE6A2188F}
AppName={#AIAppName}
AppVersion={#AIAppVersion}
AppVerName={#AIAppName} {#AIAppVersion}
AppPublisher={#AIInstallerPublisher}
AppPublisherURL={#AIAppURL}
AppSupportURL={#AIAppURL}
AppUpdatesURL={#AIAppURL}
DefaultDirName={commonpf}\{#AIAppName}
DefaultGroupName={#AIAppName}
LicenseFile={#RepoBase}\{#RepoStagingFolder}\LICENSING.txt
InfoBeforeFile={#RepoBase}\{#RepoStagingFolder}\Readme_Unicode_Version.txt

; OutputBaseFilename differs in the 5 app installers
OutputBaseFilename="Adapt_It_WX_{#AIAppUnderscoreVersion}_Unicode_Minimal" 

SetupIconFile={#RepoBase}\res\ai_32.ico
Compression=lzma/Max
SolidCompression=true
OutputDir={#RepoBase}\AIWX Installers
VersionInfoCopyright={#AIInstallerCopyright}
VersionInfoProductName={#AIAppName}
VersionInfoProductVersion={#AIAppVersion}
WizardImageFile="{#RepoBase}\res\ai_wiz_bg.bmp"
WizardSmallImageFile="{#RepoBase}\res\AILogo32x32.bmp"
WizardImageStretch=false
AppCopyright={#AIInstallerCopyright}
PrivilegesRequired=admin
DirExistsWarning=no
VersionInfoVersion={#AIAppVersion}
VersionInfoCompany=SIL
VersionInfoDescription={#AIAppName}
UsePreviousGroup=false
UsePreviousAppDir=false
DisableWelcomePage=true

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"
Name: "brazilianportuguese"; MessagesFile: "compiler:Languages\BrazilianPortuguese.isl"
Name: "french"; MessagesFile: "compiler:Languages\French.isl"
Name: "portuguese"; MessagesFile: "compiler:Languages\Portuguese.isl"
Name: "russian"; MessagesFile: "compiler:Languages\Russian.isl"
Name: "spanish"; MessagesFile: "compiler:Languages\Spanish.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked
Name: "quicklaunchicon"; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked; OnlyBelowVersion: 0,6.1

; The [Files] section below contains a list of the files that will be retrieved from
; the local machine and included within the installer created when this script is
; compiled. See the dependency script "Adapt It Unicode Git.iss" for an example of a
; special case where a temporary folder is designated by the {tmp} value is used as
; and entry in [Files], and an instance of 'DownloadPage: TDownloadWizardPage' is
; created to enable the script to be able to download (and install) an external
; installer (in our case the Git installer).
[Files]
; Note: The files included in this "Minimal" installer are just a subset of those included
; in the full installer (see and compare with [Files] in the Adapt It Unicode.iss script).
; If additions or changes are made here you need to make corresponding changes to the appropriate
; batch file(s):
;   _CopyDocs2InstallFolders.bat in docs folder
;   _CopyHelp2InstallFolders.bat in hlp folder
;   _CopyMO2InstallFolders.bat in the po folder
;   _CopyXML2InstallFolders.bat in the xml folder
; The following are the individual files (uncommented) that are included within this "minimal" installer:
Source: "{#RepoBase}\{#RepoStagingFolder}\Adapt_It_Unicode.exe"; DestDir: "{app}"; Flags: ignoreversion; 
Source: "{#RepoBase}\setup Git\{#GitDownloaderFullName}"; DestDir: "{app}"; Flags: ignoreversion;
;Source: "{#RepoBase}\{#RepoStagingFolder}\Adapt It changes.txt"; DestDir: "{app}"; Flags: ignoreversion
;Source: "{#RepoBase}\{#RepoStagingFolder}\Adapt_It_Quick_Start.htm"; DestDir: "{app}"; Flags: ignoreversion
;Source: "{#RepoBase}\{#RepoStagingFolder}\Help_for_Administrators.htm"; DestDir: "{app}"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\RFC5646message.htm"; DestDir: "{app}"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\GuesserExplanation.htm"; DestDir: "{app}"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Adapt It Reference.doc"; DestDir: "{app}"; Flags: ignoreversion
;Source: "{#RepoBase}\{#RepoStagingFolder}\Adapt It Tutorial.doc"; DestDir: "{app}"; Flags: ignoreversion
;Source: "{#RepoBase}\{#RepoStagingFolder}\Adapt_It_Unicode.htb"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#RepoBase}\{#RepoStagingFolder}\AI_UserProfiles.xml"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#RepoBase}\{#RepoStagingFolder}\AI_USFM.xml"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#RepoBase}\{#RepoStagingFolder}\books.xml"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#RepoBase}\{#RepoStagingFolder}\curl-ca-bundle.crt"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#RepoBase}\{#RepoStagingFolder}\iso639-3codes.txt"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#RepoBase}\{#RepoStagingFolder}\aiDefault.css"; DestDir: "{app}"; Flags: ignoreversion
;Source: "{#RepoBase}\{#RepoStagingFolder}\KJV 1Jn 2.12-17.txt"; DestDir: "{app}"; Flags: ignoreversion
;Source: "{#RepoBase}\{#RepoStagingFolder}\Known Issues and Limitations.txt"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#RepoBase}\{#RepoStagingFolder}\LICENSING.txt"; DestDir: "{app}"; Flags: ignoreversion; 
Source: "{#RepoBase}\{#RepoStagingFolder}\License_CPLv05.txt"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#RepoBase}\{#RepoStagingFolder}\License_GPLv2.txt"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#RepoBase}\{#RepoStagingFolder}\License_LGPLv21.txt"; DestDir: "{app}"; Flags: ignoreversion
;Source: "{#RepoBase}\{#RepoStagingFolder}\Localization_Readme.txt"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#RepoBase}\{#RepoStagingFolder}\Readme_Unicode_Version.txt"; DestDir: "{app}"; Flags: ignoreversion
; NOTE: Don't use "Flags: ignoreversion" on any shared system files
;Source: "{#RepoBase}\{#RepoStagingFolder}\SILConverters in AdaptIt.doc"; DestDir: "{app}"; Flags: ignoreversion
;Source: "{#RepoBase}\{#RepoStagingFolder}\Tok Pisin fragment 1John.txt"; DestDir: "{app}"; Flags: ignoreversion
;Source: "{#RepoBase}\{#RepoStagingFolder}\Images\Admin_help\AdminMenuSetupBECollab.gif"; DestDir: "{app}\Images\Admin_help\"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Images\Admin_help\AdminMenuSetupPTCollab.gif"; DestDir: "{app}\Images\Admin_help\"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Images\Admin_help\*.gif"; DestDir: {app}\Images\Admin_help\; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Images\Adapt_It_Quick_Start\*.gif"; DestDir: "{app}\Images\Adapt_It_Quick_Start\"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\az\Adapt_It_Unicode.mo"; DestDir: "{app}\Languages\az"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\az\az.po"; DestDir: "{app}\Languages\az"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\es\Adapt_It_Unicode.mo"; DestDir: "{app}\Languages\es"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\es\es.po"; DestDir: "{app}\Languages\es"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\es\wxstd.mo"; DestDir: "{app}\Languages\es"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\fr\Adapt_It_Unicode.mo"; DestDir: "{app}\Languages\fr"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\fr\fr.po"; DestDir: "{app}\Languages\fr"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\fr\wxstd.mo"; DestDir: "{app}\Languages\fr"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\id\Adapt_It_Unicode.mo"; DestDir: "{app}\Languages\id"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\id\id.po"; DestDir: "{app}\Languages\id"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\pt\Adapt_It_Unicode.mo"; DestDir: "{app}\Languages\pt"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\pt\pt.po"; DestDir: "{app}\Languages\pt"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\pt\wxstd.mo"; DestDir: "{app}\Languages\pt"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\ru\Adapt_It_Unicode.mo"; DestDir: "{app}\Languages\ru"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\ru\ru.po"; DestDir: "{app}\Languages\ru"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\ru\wxstd.mo"; DestDir: "{app}\Languages\ru"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\swh\Adapt_It_Unicode.mo"; DestDir: "{app}\Languages\swh"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\swh\swh.po"; DestDir: "{app}\Languages\swh"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\tpi\Adapt_It_Unicode.mo"; DestDir: "{app}\Languages\tpi"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\tpi\tpi.po"; DestDir: "{app}\Languages\tpi"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\tpi\books_tpi.xml"; DestDir: "{app}\Languages\tpi"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\tpi\tpi_readme.txt"; DestDir: "{app}\Languages\tpi"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\tpi\wxstd.mo"; DestDir: "{app}\Languages\tpi"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\zh\Adapt_It_Unicode.mo"; DestDir: "{app}\Languages\zh"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\zh\zh.po"; DestDir: "{app}\Languages\zh"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\Languages\zh\wxstd.mo"; DestDir: "{app}\Languages\zh"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\CC\Ansi2Utf8.exe"; DestDir: "{app}\CC"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\CC\CC.doc"; DestDir: "{app}\CC"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\CC\CC.hlp"; DestDir: "{app}\CC"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\CC\cc32.dll"; DestDir: "{app}\CC"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\CC\CCDebug.doc"; DestDir: "{app}\CC"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\CC\CCFiles.doc"; DestDir: "{app}\CC"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\CC\CCW32.exe"; DestDir: "{app}\CC"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\CC\CCW32.INI"; DestDir: "{app}\CC"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\CC\reverse_lx_ge.cct"; DestDir: "{app}\CC"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\CC\FwdSlashInsertAtPuncts.cct"; DestDir: "{app}\CC"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\CC\FwdSlashRemoveAtPuncts.cct"; DestDir: "{app}\CC"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\CC\Summary.doc"; DestDir: "{app}\CC"; Flags: IgnoreVersion; 
;Source: "{#RepoBase}\{#RepoStagingFolder}\CC\table series as one.cct"; DestDir: "{app}\CC"; Flags: IgnoreVersion; 
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

; Note: The following are the 13 Windows exe utilities (wrappers on python scripts) for KB Sharing
; added by whm 28 January 2021
; whm 13Feb2021 removed, since the app will incorporate c code equivalenst into the app
;Source: "{#SvnBase}\setup Unicode - Minimal\do_add_KBUsers.exe"; DestDir: "{app}\dist"; Flags: IgnoreVersion; 
;Source: "{#SvnBase}\setup Unicode - Minimal\do_change_fullname.exe"; DestDir: "{app}\dist"; Flags: IgnoreVersion; 
;Source: "{#SvnBase}\setup Unicode - Minimal\do_change_password.exe"; DestDir: "{app}\dist"; Flags: IgnoreVersion; 
;Source: "{#SvnBase}\setup Unicode - Minimal\do_change_permission.exe"; DestDir: "{app}\dist"; Flags: IgnoreVersion; 
;Source: "{#SvnBase}\setup Unicode - Minimal\do_changed_since_timed.exe"; DestDir: "{app}\dist"; Flags: IgnoreVersion; 
;Source: "{#SvnBase}\setup Unicode - Minimal\do_create_entry.exe"; DestDir: "{app}\dist"; Flags: IgnoreVersion; 
;Source: "{#SvnBase}\setup Unicode - Minimal\do_list_users.exe"; DestDir: "{app}\dist"; Flags: IgnoreVersion; 
;Source: "{#SvnBase}\setup Unicode - Minimal\do_lookup_entry"; DestDir: "{app}\dist"; Flags: IgnoreVersion; 
;Source: "{#SvnBase}\setup Unicode - Minimal\do_pseudo_delete.exe"; DestDir: "{app}\dist"; Flags: IgnoreVersion; 
;Source: "{#SvnBase}\setup Unicode - Minimal\do_pseudo_undelete.exe"; DestDir: "{app}\dist"; Flags: IgnoreVersion; 
;Source: "{#SvnBase}\setup Unicode - Minimal\do_upload_local_kb.exe"; DestDir: "{app}\dist"; Flags: IgnoreVersion; 
;Source: "{#SvnBase}\setup Unicode - Minimal\do_user_lookup.exe"; DestDir: "{app}\dist"; Flags: IgnoreVersion; 
;Source: "{#SvnBase}\setup Unicode - Minimal\do_users_list.exe"; DestDir: "{app}\dist"; Flags: IgnoreVersion; 
; Note: The following are the Windows exe utilities for KB Sharing
; added by whm 17 February 2022
Source: "{#RepoBase}\{#RepoStagingFolder}\do_mdns.exe"; DestDir: "{app}"; Flags: IgnoreVersion; 
Source: "{#RepoBase}\{#RepoStagingFolder}\mdns.exe"; DestDir: "{app}"; Flags: IgnoreVersion; 
Source: "{#RepoBase}\{#RepoStagingFolder}\do_mdns_report.exe"; DestDir: "{app}"; Flags: IgnoreVersion; 

; whm 13Feb2021 added [Dirs] section which, in this case, creates an empty "dist" directory as a 
; child directory of the {app} installation directory.
; whm 22Feb2021 removed the creation of a "dist" directory at install time after dev discussions
; decided to not use the .exe utils stored in a dist dir approach for the KB sharing feature.
;[Dirs]
;Name: "{app}\dist"

; The following [Registry] entry is used to determine if Git is installed - see the NotOnPathAlready() function
; in the [Code] section.
[Registry]
Root: HKCU; Subkey: "Environment"; ValueName: "Path"; ValueType: "string"; ValueData: "commonpf}\Git\bin;\{commonpf}\Git\cmd;{olddata}"; Check: NotOnPathAlready(); Flags: preservestringtype;

[Icons]
Name: {group}\{#AIAppName}; Filename: {app}\{#AIAppFullName}; WorkingDir: {app}; Comment: "Launch Adapt It Unicode"; 
Name: "{group}\{cm:ProgramOnTheWeb,{#AIAppShortName}}"; Filename: {#AIAppURL}; Comment: "Go to the Adapt It website at https://adapt-it.org"; 
Name: "{group}\Help for Administrators (HTML)"; Filename: "{app}\Help_for_Administrators.htm"; WorkingDir: "{app}"; Comment: "Launch Help for Administrators"; 
Name: "{group}\Adapt It Changes"; Filename: "{app}\Adapt It changes.txt"; WorkingDir: "{app}"; Comment: "Launch Adapt It changes.txt in Notepad"; 
Name: {group}\Uninstall; Filename: {uninstallexe}; WorkingDir: {app}; Comment: "Uninstall Adapt It Unicode from this computer"; 
Name: {commondesktop}\{#AIAppName}; Filename: {app}\{#AIAppFullName}; Tasks: desktopicon; 
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\Adapt It Unicode"; Filename: "{app}\{#AIAppFullName}"
Name: "{group}\CC\Consistent Changes for Windows"; Filename: "{app}\CC\CCW32.exe"; WorkingDir: "{app}\CC"; IconFilename: "{app}\CC\CCW32.exe"; Comment: "Launch Consistent Changes GUI program"; 
Name: "{group}\Consistent Changes (standalone)"; Filename: "{app}\CC\CCW32.exe"; WorkingDir: "{app}\CC"; IconFilename: "{app}\CC\CCW32.exe"; Comment: "Launch Consistent Changes GUI program"; 
Name: "{group}\CC\CC Summary Document"; Filename: {app}\CC\Summary.doc; WorkingDir: {app}\CC; 
Name: "{group}\CC\Consistent Changes Documentation"; Filename: {app}\CC\CC.doc; WorkingDir: {app}\CC; 
Name: "{group}\CC\CC Files Document"; Filename: {app}\CC\CCFiles.doc; WorkingDir: {app}\CC; 
Name: "{group}\CC\CC Debug Document"; Filename: {app}\CC\CCDebug.doc; WorkingDir: {app}\CC; 

; edb 11 Oct 2013: Code changes to download / install Git
; whm 25 Mar 2017: Code changes to enhance the installer and provide more flexible and 
; economic Git installation options.
; whm 2Jul2021 decided not to directly download the Git installer from GitHub from this 
; Adapt It Unicode - Minimal.iss script installer. If a git installation is needed on the user's
; computer, and the user choses to do so, we call our Git_Downloader_<version>_4AI.exe 
; executable file from this script as a post-install action. Calling our custom downloader
; will download the actual Git installer from GitHub and install it at Adapt It install time. 
; The 32-bit GitHub Git download URL is: 
;   https://github.com/git-for-windows/git/releases/download/v2.32.0.windows.1/Git-<version>-32-bit.exe
// whm Note: The following older github URLs are all still valid and available at the indicated
// GitHub URLs: 
// const GitSetupURL = 'https://github.com/msysgit/msysgit/releases/download/Git-1.9.5-preview20150319/Git-1.9.5-preview20150319.exe';
// const GitSetupURL = 'https://github.com/git-for-windows/git/releases/download/v2.6.2.windows.1/Git-2.6.2-32-bit.exe';
// const GitSetupURL = 'https://www.adapt-it.org/' + GitInstallerFileName;
// const GitSetupURL64 = 'https://github.com/git-for-windows/git/releases/download/v2.6.2.windows.1/Git-2.6.2-64-bit.exe';
; Note: For Windows, AI is a 32-bit application so we download and install the 32-bit version of git.
[Code]
// whm Note: Previous versions of Git that we've used in our Adapt It implementation were:
// Git version 2.08.0 (I think), version 2.12.1, version 2.18.0, and now version 2.32.0.
// whm 23Mar2017 updated the 32-bit Git download URL from adapt-it.org to Git version 2.12.1.
// whm 25Jun2018 updated the 32-bit Git download URL from adapt-it.org to Git version 2.18.0
// whm 2Jul2021 updated the 32-bit Git download URL to fetch Git version 2.32.0, and the GitSetupURL 
// to point to: 
//   https://github.com/git-for-windows/git/releases/download/v2.32.0.windows.1/Git-2.32.0-32-bit.exe

// See the contents of the @include "VersionNumbersAIandGit.h" file for the AI and GIT 
// version values currently being used.
const GitInstallerFileName = '{#GitInstallerFullName}'; // Git-2.32.0-32-bit.exe
const GitDownloaderFileName = '{#GitDownloaderFullName}'; //Git_Downloader_2_32_0_4AI.exe
const GitSetupURL = '{#GitGitHubSetupURL}';  //'https://github.com/git-for-windows/git/releases/download/v2.32.0.windows.1/Git-2.32.0-32-bit.exe';
const Btn1Desc = 'Only install Adapt It. I will use Adapt It without Git, or I will install Git later.';
const Btn2Desc = 'This option requires access to the Internet and will download about 47MB of data. ' +
                 'A copy of the Git installer is saved to the Adapt It installation directory.';
const Btn3Desc = 'This option installs Git using a previously downloaded Git installer. ' +
                 'Git can be installed this way without accesing the Internet.';
const GitDesc = 'To track changes in your translated documents, Adapt It uses a program called Git. ' +
                'You have the following Git install options:';

var GitInstalled: Boolean;  // Is Git installed?
  ShouldInstallGit: Boolean; // should the installer download and run the Git installer?
  GitInstallerExistsLocally: Boolean; // for user selectable option to use existing Git installer if it exists
  tmpResult: Integer; // for Exec() command error tracking
  PathToAIInstallation: string; // holds the result of expandconstant('{app}') in the GitInstallOptionsPageID case of the NextButtonClick() function below.     
  GitInstallerPathAndName: string;  // holds the path and name of the local copy of the Git installer, normally C:\Program Files (x86)\Adapt It WX Unicode\Git-<-32-bit.exe
  GitDownloaderPathAndName: string; // holds the path and name of the local copy of the Git downloader, normally C:\Program Files (x86)\Adapt It WX Unicode\Git_Downloader_<version>_4AI.exe
  msg: string; // for MsgBox messages
  GitInstallOptionsPageID: Integer;
  GitInstallOptionsPage: TWizardPage; // our Git installer page added to the Setup routine
  //DownloadPage: TDownloadWizardPage;  // whm added 18Jun2021; removed 2Jul2021
  NoInsGitRadioButton: TNewRadioButton;
  NoInsGitDescLabel: TLabel;
  InsGitFmNetRadioButton: TNewRadioButton;
  InsGitFmNetDescLabel: TLabel;
  InsGitFmFileRadioButton: TNewRadioButton;
  InsGitFmFileDescLabel: TLabel;

// whm 18Jun2021 added the following OnDownloadProgress function (from Inno example CodeDownloadFiles.iss)
function OnDownloadProgress(const Url, FileName: String; const Progress, ProgressMax: Int64): Boolean;
begin
  if Progress = ProgressMax then
    Log(Format('Successfully downloaded file to {tmp}: %s', [FileName]));
  Result := True;
end;

// The following 2 functions taken from the Inno example CodeDownloadFiles.iss
function CreateRadioButton(rbParent: TWizardPage; rbTop: Integer; rbChecked: Boolean; 
         rbCaption: string): TNewRadioButton;
begin
  Result := TNewRadioButton.Create(WizardForm);
  with Result do
  begin
    Parent := rbParent.Surface;
    Top := rbTop;
    Width := rbParent.SurfaceWidth;
    Font.Style := [fsBold];
    Font.Size := 9
    Caption := rbCaption;
    Checked := rbChecked;
  end;
end;

function CreateBtnDescLabelBelowBtn (rbParent: TWizardPage; rbTop: Integer; 
         rbCaption: string): TLabel;
begin
  Result := TLabel.Create(WizardForm);
  with Result do
  begin
    Parent := rbParent.Surface;
    Left := 12;
    Top := rbTop;
    Width := rbParent.SurfaceWidth; 
    Height := 30;
    AutoSize := False;
    Wordwrap := True;
    Caption := rbCaption;
  end
end;

// This InitializeWizard() procedure is an event function where we can make changes to the wizard 
// or wizard pages at startup. We create our custom wizard page here with its 3 radio button 
// controls, and examine the Windows registry to determine if Git has been installed or no. 
// You can't use the similar InitializeSetup event function for creating wizard pages and controls
//  since at the time InitializeSetup is triggered, the wizard form does not yet exist.
procedure InitializeWizard();
begin

    // whm addition 24March2017
    // ========= Create Custom GitInstallOptionsPage with 3 radio buttons and short description labels ========
    GitInstallOptionsPage := CreateCustomPage(wpSelectTasks, 'Adapt It needs to install a program called Git', GitDesc);
    GitInstallOptionsPageID := GitInstallOptionsPage.ID;

    // whm 18Jun2021 added following initialization of DownloadPage
    // whm 2Jul2021 decided to use Exec() to call our custom Git Downloader 
    // instead of creating a DownloadPage in this script.
    //DownloadPage := CreateDownloadPage(SetupMessage(msgWizardPreparing), SetupMessage(msgPreparingDesc), @OnDownloadProgress);

    // See the CurPageChanged() procedure for comments about the radio button defaults, which are set in that 
    // procedure to be the most likely selection desired by an administrator/user.
    NoInsGitRadioButton := CreateRadioButton(GitInstallOptionsPage, 12, False, 'Do not try to install Git at this time');
    NoInsGitDescLabel := CreateBtnDescLabelBelowBtn(GitInstallOptionsPage, NoInsGitRadioButton.Top + 20, Btn1Desc);
  
    InsGitFmNetRadioButton := CreateRadioButton(GitInstallOptionsPage, 68, True, 'Download and install Git from the Internet');
    InsGitFmNetDescLabel := CreateBtnDescLabelBelowBtn(GitInstallOptionsPage, InsGitFmNetRadioButton.Top + 20, Btn2Desc);
  
    InsGitFmFileRadioButton := CreateRadioButton(GitInstallOptionsPage, 128, False, 'Browse this computer to find a Git installer');
    InsGitFmFileDescLabel := CreateBtnDescLabelBelowBtn(GitInstallOptionsPage, InsGitFmFileRadioButton.Top + 20, Btn3Desc);
    // ========= Create Custom GitInstallOptionsPage with 3 radio buttons and short description labels ========

    WizardForm.LicenseAcceptedRadio.Checked := True; // make the default choice True

    // whm Note: I learned from experience that here in InitializeWizard is too early to expand 
    // some constants like {app} which is not initialized until later in the wizard setup process. 
    // If you try to get a value for {app} here it results in a run-time error: "attempt to expand 
    // the {app} var before it was initialized." Exception: {tmp} can be expanded here within
    // InitializeWizard, as Erik employed it here. 

    // whm Note: Previously the ITD InnoTools Downloader was initialized here with the following calls:
    //ITD_Init; // initialize the (ITD) InnoTools Downloader
    //ITD_DownloadAfter(wpReady);

    // Test for Git by looking for its uninstaller in the registry.
    // whm modified 22March2017 Registry keys are not supposed to be case sensitive, but in testing
    // if the key has ...\Wow6432Node\ instead of ...\WOW6432Node\... the test below fails. Probably
    // the failure is due to the RegKeyExists() function making a case-sensitive comparison. This used
    // to work, so perhaps an earlier version of Inno Setup had a non-case-sensitive comparison? Maybe
    // some versions of Windows store the key as Wow6432Node and other versions as WOW6432Node. In any 
    // case to prevent problems for the Adapt It installer, we'll test key strings containing both 
    // Wow6432Node and WOW6432Node.
    // check for 64-bit Windows - the lower case Wow6432Node version
    if (RegKeyExists(HKLM, 'SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall\Git_is1')) then
        GitInstalled := True;
    // check for 64-bit Windows - the upper case WOW6432Node version
    if (RegKeyExists(HKLM, 'SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\Git_is1')) then
        GitInstalled := True;
    // check for 32-bit Windows
    // whm Note: The if test resolves to True even on 64-bit systems, probably do to the 'Wow6432Note' magic
    if (RegKeyExists(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Git_is1')) then
        GitInstalled := True;
end;

// The wizard calls this ShouldSkipPage() event function to determine whether or not a 
// particular page (specified by PageID) should be shown at all. If the function returns
// True, the page will be skipped; if it returns False, the page may be shown. 
// Note: This event function isn't called for the wpPreparing, and wpInstalling pages, 
// nor for pages that Setup has already determined should be skipped (for example, 
// wpSelectComponents in an install containing no components).
function ShouldSkipPage(PageID: Integer): Boolean;
begin
  // Initialize result to not skip any page (not necessary, but safer)
  Result := False;
  // If the page should be skipped (omitted from the wizard) assign Result to True.
  if PageID = GitInstallOptionsPageID then
  begin
    Result := GitInstalled;
  end
end;

// The CurPageChanged() procedure is called after a new wizard page (specified by CurPageID) 
// is shown - before the user has a chance to interact with the page. It is therefore one
// place we can set some initial defaults for the controls on the page - possibly as the
// result of previous wizard page setting of boolean variables.
procedure CurPageChanged(CurPageID: Integer);
begin
  if CurPageID = GitInstallOptionsPageID then 
  begin
    // The GitInstallOptionsPage shows in the wizard when GitInstalled is False, so
    // that's how we got here.
    // We try to be smart about what Git install option button should be pre-selected.
    // If there is a local Git installer available already on the local machine, the third 
    // option "Browse this computer to find a Git installer" should probably be the first
    // choice since it will be faster, and cheaper (no Internet data required) to do the 
    // Git installation by just running the local Git installer. So, if we detect the 
    // existence of a local Git installer, we set the default radio button of the 
    // GitInstallOptionsPage to be the third option: "Browse this computer to find a Git 
    // Installer" (and the other radio buttons to False).
    // If there is no local copy of the installer where we would expect it, that probably
    // means that this computer has not had Adapt It on it before - at least not installed
    // with this version of our Inno Setup script that saves a copy of the installer in
    // a known place. So, I think next logical button choice would probably be to try 
    // to install Git from the Internet - by pre-selecting the "Download and install Git 
    // from the Internet" button. The installer will balk if the download can't 
    // proceed due to bad or non-existing Internet access. A lot of users, especially 
    // administrators doing the installation of Adapt It on a single machine would have 
    // decent Internet.
    // Although the "Do not try to install Git at this time" option is available I don't
    // think there is a well-defined scenario where we would have that option be the 
    // initial button selection, but we have to include it as an option.
    GitInstallerExistsLocally := FileExists(GitInstallerPathAndName);
    if GitInstallerExistsLocally then
    begin
      NoInsGitRadioButton.Checked := False;
      InsGitFmNetRadioButton.Checked := False;
      InsGitFmFileRadioButton.Checked := True;
    end
    else
    begin
      // No Git installer exists locally that we are aware of or can find.
      // Make the initial selection be to Download and install Git from the Internet"
      NoInsGitRadioButton.Checked := False;
      InsGitFmNetRadioButton.Checked := True;
      InsGitFmFileRadioButton.Checked := False;
    end;
  end
end;


// The NextButtonClick() function is called when the user clicks the Next button.
// The CurPage's controls can be read at this point and variables assigned from
// the controls' values.
// If the function is set to a True Result, the wizard will move to the next page.
// If the function is set to a False Result, it will remain on the current page.
function NextButtonClick(CurPage: Integer): Boolean;
var
  Prompt: String;
  FileName: String;
  Filter: String;
  InitialDirectory: String;
  UseFileDialog: Boolean;
begin
  UseFileDialog := False;
  // Note: The wizard pages, when they appear, follow the order they are listed in the
  // case statement below. We only give special treatment for some of them here in
  // NexButtonClick().
	case CurPage of
		wpWelcome : // disabled in [Setup]
		  ;
		wpLicense : // shows content of LICENSING.txt
		  ;
		wpInfoBefore : // shows content of Readme_Unicode_Version.txt
		  ;
		wpSelectDir :
    begin
      // Previous version of script downloaded the Git installer to a tmp file called GitInstaller.exe
      // and the tmp download gets automatically removed after it is executed. We now want to save a
      // copy of the Git installer by its actual name (with version numbers), so it can be utilized for
      // subsequent downloads on the local computer or copied to a thumb drive to use for installation
      // on other computers.
      // Create the C:\Program Files (x86)\Adapt It WX Unicode\ dir if it doesn't exist so
      // we can save a copy of the downloaded installer there.
      if DirExists(PathToAIInstallation) = False then
      begin
        CreateDir(PathToAIInstallation);
      end;
      // Check if GitInstaller.exe exists in the {app} folder. If so we can offer to use if the user
      // opts to use a previously downloaded copy of the Git installer.
      GitInstallerExistsLocally := FileExists(GitInstallerPathAndName);
    end;
		wpSelectComponents : // whm Note: this wizard page "could" be used to reduce our AI installers to just 
    // one for Windows. A Select Components wizard page could have check boxes that would allow users to use
    // the same installer to download install AI and/or its components. A wpSelectComponents page might have 
    // the following components:
    // [ ] "Install the Adapt It Unicode main program" [normally selected by defaul unless the same version already is installed]
    // [ ] "Install Git" [auto checked if no Git installation was found by Setup]
    // [ ] "Install Adapt It Documentation" [would eliminate the need for other less-than-full installers]
    // [ ] "Install Adapt It Localization" [would eliminate the need for other less-than-full installers]
    // However, using a Select Components wizard page would likely complicate things somewhat for us and 
    // might not be very intuitive for many less experienced users - especially if they have downloaded
    // and installed Adapt It in the past. Our adapt-it.org website shows the "full" installer as the one
    // that gets downloaded, unless the user scrolls down and clicks on the "other installations" link to
    // access download links for the other less-than-full installers as well as other downloadable items.
    // Some users who opt to only download a less-than-full install - by unticking components - might not
    // realize that they would need to use the same installer a second time to download other components
    // that they didn't download/install previously. 
		  ;
		wpSelectProgramGroup : // set name of Start Menu Folder (default: Adapt It WX Unicode)
		  ;
		wpSelectTasks :  // provides a checkbox: Create a desktop shortcut
		  ;
    GitInstallOptionsPageID :  // our "smart" custom page for setting Git install options
    begin
      // Initialize some variables
      GitInstalled := False;
      ShouldInstallGit := False;
      GitInstallerExistsLocally := False;
      GitInstallerPathAndName := expandconstant('{app}\' + GitInstallerFileName);
      GitDownloaderPathAndName := expandconstant('{app}\' + GitDownloaderFileName);
      PathToAIInstallation := expandconstant('{app}');

      // Compose detailed messages to present to the administrator/user that are context sensitive.
      //
      if NoInsGitRadioButton.Checked then // TOP radio button is selected
      begin
        // An administrator may change a default selection from third option "Browse this computer to find 
        // a Git installer", to the first option: "Do not try to install Git at this time" button for economic 
        // reasons (expensive Internet access) even before s/he realizes that there is a local copy of the 
        // installer already available residing on the user's computer (the reason why the 3rd option was
        // auto-selected). 
        msg := 'You chose not to download and install the Git program from the Internet as part of the ' +
               'Adapt It installation. Adapt It will still run, but unless Git is installed, ' +
               'Adapt It will not be able to track historical changes in your translated documents ' +
               'and it will not be able to restore a previous version from that history.' + Chr(13);
        If GitInstallerExistsLocally then
        begin
          // Add the following to the initial msg above:
          // We remind the administrator/user that a local Git installer is available and we recommend they
          // install Git now while they are in the Adapt It installer.
          msg := msg + 'Please note however, that a Git installer is available on this computer at:' + Chr(13) + 
                 '     ' + GitInstallerPathAndName + '.' + Chr(13) +
                 'That installer could be used to install Git without accessing the Internet. ' +
                 'We recommend that you click on OK below, then click on the Back button and select the ' +
                 'option "Browse this computer to find a Git installer...". ' +
                 'The installer will help you install Git before you finish using this installer.' + Chr(13) + Chr(13);
        end
        else
        begin
          // No Git installer found locally
          msg := msg + 'If you have not previously downloaded the Git installer (47MB) and you have Internet access, ' +
               'the recommended way to obtain the Git program is to run the Adapt It installer again and choose ' +
               'to have it automatically download and install the Git program with the correct settings.' + Chr(13) + Chr(13);
        end;
        // Also remind the administrator/user that once Git has been downloaded once, that
        // installer will be preserved in the Adapt It installation folder where it could be
        // copied to a USB drive and made available when Adapt It and Git are installed on other
        // computers - making it possible to install Adapt It and Git on multiple computers once
        // the first installation has been done.
        msg := msg + 'You should know that the Adapt It installer now saves a copy of the Git installer the first time it is ' + 
               'downloaded from the Internet. That copy of the Git installer is preserved in the Adapt It ' +
               'installation folder located at:' + Chr(13) + 
               '     '  + PathToAIInstallation + '.' + Chr(13) + 
               'You can use the local copy of the Git installer to install Git on this computer by running ' +
               'this installer again, or by transfering this installer and the Git installer via thumb drive ' +
               'to the other computer, and running this installer on that other computer.' + Chr(13) + Chr(13);

        // Also, tell the administrator that if they want to install Git apart from using this installer,
        // they can do so from a cmd terminal call, supplying the /SILENT option on the command line, 
        // which will cause it to be installed without any prompts - accepting all the default options 
        // required during the installation - as this installer does.
        msg := msg + 'The Git installer can be downloaded separately (from: https://git-scm.com/downloads) ' +
               'and installed at a later time apart from using this installer. It you decide to install Git ' +
               'that way, you should run the Git installer in a cmd window using this command:' + Chr(13) +
               '     ' + GitInstallerFileName + ' /SILENT';
        MsgBox(msg, mbInformation, MB_OK);
      end
      else if InsGitFmNetRadioButton.Checked then  // MIDDLE radio button is selected
      begin
        // whm 2Jul2021 Note:
        // Previously we created a DownloadPage to download the Git installer from within
        // this main AI Installer script. However, since we want to be able to programatically
        // download Git also from the source code in our main application, I've removed that downloading
        // and installation of Git functionality from this main installer, and instead put the
        // creation and execution of the DownloadPage into our custom Adapt It Unicode Git.ixx script
        // that creates our Git_Downloader_<version>_4AI.exe installer. This Git Downloader is called by
        // Exec() below from within this installer, and can also be called by wxExecute() within our
        // main appliication code to download and install Git when Tools > Install the git program... is
        // selected.
        // See the Adapt It Unicode Git.iss script for the details

        // Inform the CurStepChanged() procedure below to proceed to download and install Git 
        ShouldInstallGit := True;
      end
      else if InsGitFmFileRadioButton.Checked then  // BOTTOM radio button is selected
      begin
        // Check if a suitable Git installer exists in the local {app} folder. If so we can offer 
        // to use it since the user has chosen to use a previously downloaded copy of the Git installer.
        // GitInstallerExistsLocally was set in the earlier wpSelectDir wizard page above
        GitInstallerExistsLocally := FileExists(GitInstallerPathAndName);
        if GitInstallerExistsLocally then
        begin
          if (MsgBox('A Git installer is available on this computer at: ' + GitInstallerPathAndName + '.' + Chr(13) +
                 'That installer could be used to install Git without accessing the Internet. ' +
                 'Do you want Adapt It to install Git now using that installer?', mbConfirmation, MB_YESNO) = IDYES) then
          begin
            // Call Exec() to install Git with the /SILENT switch. The Git installer has a nice, compatible 
            // GUI that shows progress of the installation.
            Exec(GitInstallerPathAndName, '/SILENT', '', SW_SHOW, ewWaitUntilTerminated, tmpResult);
            if (tmpResult = 0) then
            begin
              // Executing the Git installer succeeded and so returned 0 - an error would return an exit error code
              ShouldInstallGit := False;
            end
            else
            begin
            // Executing the Git installer from the usual place failed, notify the user
            msg := 'ERROR: Running the selected Git installer encountered an error (error code: ' + IntToStr(tmpResult) + ').' + Chr(13) +
                'Please try again by browsing to a different Git installer, or choose a different option from this dialog.';
              MsgBox(msg, mbInformation, MB_OK);
              Result := False; 
              // Assigning False to Result causes the wizard page to stay on the GitInstallOptionsPageID where 
              // a different radio button option may be selected - such as middle option (install from Internet) 
              // or the top option (don't install Git)
            end;
          end
          else
          begin
            UseFileDialog := True;
            // File dialog routine called below
          end
        end
        else
        begin
           // GitInstallerExistsLocally was False
           UseFileDialog := True;
        end;
        if UseFileDialog then
        begin
            // User opted to not use the existing Git installer that we found, perhaps because
            // the user wants to use a different (updated) one from a thumb drive, so present 
            // the file dialog and allow navigating to the desired installer.
            Prompt := 'Select a Git installer file, for example' + GitInstallerFileName + ' [version numbers may vary]';
            FileName := 'Git-*.exe';
            InitialDirectory := PathToAIInstallation;
            Filter := 'Git installer (*.exe)|*.exe|All Files|*.*';
            if GetOpenFileName(Prompt, FileName, InitialDirectory, Filter, 'exe') then
            begin
              // Successful; user clicked OK
              // FileName contains the selected filename
              GitInstallerPathAndName := FileName;
              // Install Git with the /SILENT switch. The Git installer has a nice, compatible GUI that
              // shows progress of the installation.
              Exec(GitInstallerPathAndName, '/SILENT', '', SW_SHOW, ewWaitUntilTerminated, tmpResult);
              if (tmpResult = 0) then
              begin
                // Executing the Git installer succeeded and so returned 0 - an error would return an exit error code
                ShouldInstallGit := False;
              end
              else
              begin
                // Executing the Git installer from the chosen location failed, notify the user
                msg := 'ERROR: Running the selected Git installer encountered an error (error code: ' + IntToStr(tmpResult) + ').' + Chr(13) +
                    'Please try again by browsing to a different Git installer, or choose a different option from this dialog.';
                  MsgBox(msg, mbInformation, MB_OK);
                Result := False; 
                // Assigning False to Result causes the wizard page to stay on the GitInstallOptionsPageID where 
                // a different radio button option may be selected - such as middle option (install from Internet) 
                // or the top option (don't install Git)
              end;
            end
            else
            begin
               // User canceled from the GetOpenFileName dialog
               MsgBox('No Git Installer was selected. Git will not be installed if you continue.' + Chr(13) +
                      'If you still want to install Git, after you click OK, you can click the ' +
                      'Back button to access the Git install options page, and try again.', mbInformation, MB_OK);
            end;
            UseFileDialog := False;        
        end;
      end;
    end;
		wpReady :
      ;
		wpPreparing :
		  ;
		wpInstalling :
		  ;
		wpInfoAfter :
		  ;
		wpFinished :
		  ;
	else
		;
	end;
  Result := True;
end;

// The CurStepChanged() procedure can be used to perform your own pre-install and 
// post-install tasks. If CurStep=ssInstall is used it executes just before the actual 
// installation starts, with CurStep=ssPostInstall it executes just after the actual 
// installation finishes, and with CurStep=ssDone just before Setup terminates after 
// a successful install. We use it only as CurStep=ssPostInstall.
procedure CurStepChanged(CurStep: TSetupStep);
begin
  if CurStep=ssPostInstall then
    // Silently run the Git installer as a post-install step
    if (ShouldInstallGit = True) then begin
      // Run our custom git downloader silently. 
      // Our custom git downloader executable is made in Inno as well;
      // more info on the command line options for Inno installers can be
      // found here: http://www.jrsoftware.org/ishelp/index.php?topic=setupcmdline
      // whm 2Jul2021 changed Exec() command below to use GitDownloaderPathAndName 
      // instead of GitInstallerPathAndName.
      // The installer also needs to be run with the /NORESTART switch to suppress 
      // the restart message. 
      // Note: The "Needs Restart" message is provided in the AI source code in the
      // CInstallGitOptionsDlg class handlers.
      Exec(GitDownloaderPathAndName, '/SILENT', '', SW_SHOW, ewWaitUntilTerminated, tmpResult); // runs our custom git downloader/installer
      if (not tmpResult = 0) then
      begin
        MsgBox('ERROR: Setup was not able to run the Adapt It Git Downloader ' + GitDownloaderFileName + 
        ' which it expected to find at: ' + GitDownloaderPathAndName + Chr(13) +
        'The installation of Adapt It succeeded, but the Git program is NOT yet properly installed on this computer. ' +
        'We recommend that you try to manually download and install the Git installer from this website on the Internet:' + Chr(13) +
        GitSetupURL, mbError, MB_OK)
      end
    end;
end;

// The NotOnPathAlready() function is used in the [Registry] section to ensure the 
// Windows path to Git is set properly.
function NotOnPathAlready(): Boolean;
var
  BinDir, Path: String;
begin
  if RegQueryStringValue(HKEY_CURRENT_USER, 'Environment', 'Path', Path) then
  begin // Successfully read the value
    Log('HKCU\Environment\PATH = ' + Path);
    BinDir := ExpandConstant('{commonpf}\Git\bin');
    Log('Looking for Git\bin dir in %PATH%: ' + BinDir + ' in ' + Path);
    if Pos(LowerCase(BinDir), Lowercase(Path)) = 0 then
    begin
      Log('Did not find Git\bin dir in %PATH% so will add it');
      Result := True;
    end
    else
    begin
      Log('Found Git\bin dir in %PATH% so will not add it again');
      Result := False;
    end
  end
  else // The key probably doesn't exist
  begin
    Log('Could not access HKCU\Environment\PATH so assume it is ok to add it');
    Result := True;
  end;
end;

// The NeedRestart() function Return True to instruct Setup to prompt the user 
// to restart the system at the end of a successful installation, False otherwise.
function NeedRestart(): Boolean;
begin
  // If Git was installed, prompt the user to reboot after everything's done
  Result := ShouldInstallGit;
end;

// A [Run] section in this script suppresses the launch option at end of installation
[Run]
Filename: "{app}\{#AIAppFullName}"; Description: "{cm:LaunchProgram,{#StringChange(AIAppName, "&", "&&")}}"; Flags: nowait postinstall skipifsilent
